#pragma once

#include "gmplugin.h"

struct User
{
	char Nick[256];
	char Modes;
};

struct ircChannel
{
	char Name[256];
	DynamicVectorClass<User *> Users;
};

struct RConnect
{
	int count;
	char host[256];
};

struct ircdata
{
	DynamicVectorClass<ircChannel *> Channels;
	TCPSocket Sock;
	char Host[128];
	char Backup_Host[128];
	char Nick[128];
	char Backup_Nick[128];
	char NSPassword[128];	
	int Port;
	int Backup_Port;
	void (*Callback)(ircdata *, const char *);
	int ThinkScript;
	bool Ghost;
	bool Ping;
};

class IRC
{
	static ircdata* Data;
	static char Buffer[1024];
	static clock_t Activity;
public:
	static int Position;
	static void Load();
	static void Unload();

	static const char *IRC::Connect(ircdata **Data, const char *Host, int Port, const char *Nick, const char *NickBackup, const char *NSPassword);
	static void Send(const char *Packet, ...);
	static void __stdcall SendC(int Type, const char *Message, ...);
	static void SendC(const char *Channel, const char *Packet, ...);
	static void SendALL(const char *Packet, ...);
	static void Disconnect(const char *Message, ...);
	static void Disconnect();
	static bool Find_Status(const char *Nick, const char *Channel, char *access);
	static void Callback(ircdata *irc, const char *Packet);
	static void Think();
	static void On_Chat(StringClass Nick, StringClass Channel, Tokenizer Msg);

	// hashed IRC commands/numerics that benefit from hash compares instead of string compares
	static void Load_Hashes();
	static uint PINGHash, Numeric433Hash, Numeric001Hash, PRIVMSGHash;

	// mIRC colours
	static void Load_Colours();
	static StringClass White, Black, Blue, Green, Red, Brown, Purple, Orange, Yellow, 
		LightGreen, Cyan, LightCyan, LightBlue, Pink, Grey, LightGrey, NoMarkup, Bold;
};